# ![Boost.Log](doc/logo.png)

Boost.Log, part of collection of the [Boost C++ Libraries](https://github.com/boostorg), provides tools for adding logging to libraries and applications.

### Directories

* **build** - Boost.Log build scripts
* **config** - Boost.Log build configuration code and scripts
* **doc** - QuickBook documentation sources
* **example** - Boost.Log examples
* **include** - Interface headers of Boost.Log
* **src** - Compilable source code of Boost.Log
* **test** - Boost.Log unit tests

### More information

* [Documentation](https://www.boost.org/libs/log)
* [Ask questions](https://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-log)
* [Report bugs](https://github.com/boostorg/log/issues/new). Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as [pull requests](https://github.com/boostorg/log/compare) against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](https://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](https://www.boost.org/community/policy.html) before posting and add the `[log]` tag at the beginning of the subject line.

### Build status

Branch          | GitHub Actions | AppVeyor | Test Matrix | Dependencies |
:-------------: | -------------- | -------- | ----------- | ------------ |
[`master`](https://github.com/boostorg/log/tree/master) | [![GitHub Actions](https://github.com/boostorg/log/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/boostorg/log/actions?query=branch%3Amaster) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/w7x67cnm82xihei5/branch/master?svg=true)](https://ci.appveyor.com/project/Lastique/log/branch/master) | [![Tests](https://img.shields.io/badge/matrix-master-brightgreen.svg)](https://regression.boost.io/master/developer/log.html) | [![Dependencies](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/log.html)
[`develop`](https://github.com/boostorg/log/tree/develop) | [![GitHub Actions](https://github.com/boostorg/log/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/boostorg/log/actions?query=branch%3Adevelop) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/w7x67cnm82xihei5/branch/develop?svg=true)](https://ci.appveyor.com/project/Lastique/log/branch/develop) | [![Tests](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](https://regression.boost.io/develop/developer/log.html) | [![Dependencies](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/log.html)

### License

Distributed under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
